---
title: Numbers and units of measurement · Cloudflare Style Guide
description: Be consistent in your use of numbers. Use numerals for numbers.
  When you write about numbers used in examples or UI, duplicate them exactly as
  they appear in the UI. In all other content, follow the guidelines below.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/numbers-and-units-of-measurement/
  md: https://developers.cloudflare.com/style-guide/formatting/numbers-and-units-of-measurement/index.md
---

**Be consistent in your use of numbers.** Use numerals for numbers. When you write about numbers used in examples or UI, duplicate them exactly as they appear in the UI. In all other content, follow the guidelines below.

In body text, spell out whole numbers from zero through nine.

* Example: We have added three more servers.

For numbers greater than or equal to 10, use digits.

* Example: The message is 32 bytes long, \[...]

For analytics, display metrics with numerals. Use commas for numbers with more than 3 digits (no spaces). Note the differences in numerical punctuation for translation.

* 300
* 1,000
* 7,465

## Using k to indicate thousands

Do not put a space between the number and k.

Add a noun to indicate what the number measures, and to make clear that you are not using k as an abbreviation for *kilobytes*.

* Example: On this plan, you are limited to 55k download operations and 20k upload operations per day.

## Units of measurement

Units of measurement can occur in two different contexts.

### As nouns

The storage provider landscape has become highly competitive with many providers capable of providing **petabyte** (and **exabyte**) scale content storage at extremely low cost-per-**gigabyte**.

### As modifiers of numbers

Many CPU architectures either do not allow execution of the machine code, which is unaligned in memory (**4 KB** for x86 systems)

In general, only abbreviate units of measurements when they modify specific quantities/numbers. When you need to abbreviate them:

| ✅ | ❌ | Rationale |
| - | - | - |
| 10 m | 10m | Always include a space between the number and the unit |
| 10 cm | 10 cms | Unit symbols should unaltered in the plural. |

**Always include a space between a numerical value and the corresponding unit of measurement.** Although both formats are widely used, the metric system standardized the use of a space before a unit of measurement and should be used as a guideline to keep content consistent and clear.

| ✅ | ❌ | Rationale |
| - | - | - |
| 128 GB | 128 gb, 128gb, 128GB | Units of measurement should always be capitalized and spaced out from their corresponding numerical values. |
| This network has a capacity of over **30 Tbps.** | This network has a capacity of over 30Tbps. | Adding a space between ‘30’ and ‘Tbps’ makes this sentence easier to read. |

## Physical distance

| Measurement | Example |
| - | - |
| inches | Although Harvey's category was quickly downgraded, the storm lingered around for days, bringing 50 **inches** of rain to the greater Houston area. |
| feet, meters | At 2625 **meters** (8612 **feet**) above sea level, Bogotá (Colombia) is one of the four highest capital cities in the world. Now, it is also home to Cloudflare's 149th data center. |
| miles | Despite having a unique place on the map of the United States, and its significant distance from other cities (900 **miles** to Dallas; 1,000 **miles** to Chicago, 1,000 **miles** to Los Angeles), Denver has not always been a major point of regional interconnection. |

## Digital storage

| Measurement | Example |
| - | - |
| Bit (b) | Typical RSA key sizes are 1,024 or 2,048 or 4,096 **bits**. |
| Byte (B) | Here is a small program that creates a lot of garbage. Once a second it asks for a byte array of between 5,000,000 and 10,000,000 **bytes**. |
| Kilobyte (KB) | Internally, ACME never stores objects that are larger than a configured size (32 **kilobytes**, by default). Many CPU architectures either do not allow execution of the machine code, which is unaligned in memory (4 **KB** for x86 systems). |
| Megabyte (MB) | To do that, we extracted one batch of records from ACME and ran some benchmarks on it. All batches are around 1 **MB** uncompressed, 600 records in each on average. Additionally, we had a two **megabyte** maximum size for values. We have increased the limit for values to ten **megabytes**. |
| Gigabyte (GB) | Pro plans will be able to use up to 5 **gigabytes** for free each month. Biz plans can go up to 10 **GB** for free. |
| Terabyte (TB) | Fortunately, I came across Cloudflare. In the month of October alone, CloudFlare has saved us about 1.54 **TB**. That is 500 **terabytes**, 500 million **megabytes**, or approximately the equivalent data contained in 1 billion books. |
| Petabyte (PB) | PB |
| Exabyte (EB) | EB |
| Zettabyte (ZB) | ZB |
| Yottabyte (YB) | YB |
