---
title: Short-lived certificates (legacy) · Cloudflare One docs
description: Cloudflare Access can replace traditional SSH keys with short-lived
  certificates issued to your users based on the token generated by their Access
  login. In traditional models, users generate an SSH key pair and
  administrators grant access to individual SSH servers by deploying their
  users' public keys to those servers. These SSH keys can remain unchanged on
  these servers for months or years. Cloudflare Access removes the burden of
  managing SSH keys, while also improving security by replacing long-lived SSH
  keys with ephemeral SSH certificates.
lastUpdated: 2025-10-27T15:01:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/short-lived-certificates-legacy/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/short-lived-certificates-legacy/index.md
---

Note

Not recommended for new deployments. We recommend using [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) to configure short-lived certificates for SSH.

Cloudflare Access can replace traditional SSH keys with short-lived certificates issued to your users based on the token generated by their Access login. In traditional models, users generate an SSH key pair and administrators grant access to individual SSH servers by deploying their users' public keys to those servers. These SSH keys can remain unchanged on these servers for months or years. Cloudflare Access removes the burden of managing SSH keys, while also improving security by replacing long-lived SSH keys with ephemeral SSH certificates.

## 1. Secure the server behind Cloudflare Access

Cloudflare Access short-lived certificates can work with any modern SSH server, whether it is behind Access or not. However, we recommend putting your server behind Access for added security and features, such as auditability and browser-based terminals.

To secure your server behind Cloudflare Access:

1. [Connect the server to Cloudflare](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/) as a published application.
2. Create a [self-hosted Access application](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/) for the server.

Note

If you do not wish to use Access, refer instead to our [SSH proxy instructions](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/ssh-logging/).

## 2. Ensure Unix usernames match user SSO identities

Cloudflare Access will take the identity from a token and, using short-lived certificates, authorize the user on the target infrastructure.

The simplest setup is one where a user's Unix username matches their email address prefix. Issued short-lived certificates will be valid for the user's email address prefix. For example, if a user in your Okta or GSuite organization is registered as `jdoe@example.com`, they would log in to the SSH server as `jdoe`.

For testing purposes, you can run the following command to generate a Unix user on the machine:

```sh
sudo adduser jdoe
```

Advanced setup: Differing usernames

SSH certificates include one or more `principals` in their signature which indicate the Unix usernames the certificate is allowed to log in as. Cloudflare Access will always set the principal to the user's email address prefix. For example, when `jdoe@example.com` tries to connect, Access issues a short-lived certificate authorized for the principal `jdoe`.

By default, SSH servers authenticate the Unix username against the principals listed in the user's certificate. You can configure your SSH server to accept principals that do not match the Unix username.

Note

If you would like to use short-lived certificates with the browser-based terminal, the user's email address prefix needs to matches their Unix username.

**Username matches a different email**

To allow `jdoe@example.com` to log in as the user `johndoe`, add the following to the server's `/etc/ssh/sshd_config`:

```txt
Match user johndoe
  AuthorizedPrincipalsCommand /bin/echo 'jdoe'
  AuthorizedPrincipalsCommandUser nobody
```

This tells the SSH server that, when someone tries to authenticate as the user `johndoe`, check their certificate for the principal `jdoe`. This would allow the user `jdoe@example.com` to sign into the server with a command such as:

```sh
ssh johndoe@server
```

**Username matches multiple emails**

To allow multiple email addresses to log in as `vmuser`, add the following to the server's `/etc/ssh/sshd_config`:

```txt
Match user vmuser
  AuthorizedPrincipalsFile /etc/ssh/vmusers-list.txt
```

This tells the SSH server to load a list of principles from a file. Then, in `/etc/ssh/vmusers-list.txt`, list the email prefixes that can log in as `vmuser`, one per line:

```txt
jdoe
bwayne
robin
```

**Username matches all users**

To allow any Access user to log in as `vmuser`, add the following command to the server's `/etc/ssh/sshd_config`:

```txt
Match user vmuser
  AuthorizedPrincipalsCommand /bin/bash -c "echo '%t %k' | ssh-keygen -L -f - | grep -A1 Principals"
  AuthorizedPrincipalsCommandUser nobody
```

This command takes the certificate presented by the user and authorizes whatever principal is listed on it.

**Allow all users**

To allow any Access user to log in with any username, add the following to the server's `/etc/ssh/sshd_config`:

```txt
AuthorizedPrincipalsCommand /bin/bash -c "echo '%t %k' | ssh-keygen -L -f - | grep -A1 Principals"
AuthorizedPrincipalsCommandUser nobody
```

Since this will put the security of your server entirely dependent on your Access configuration, make sure your [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/policy-management/) are correctly configured.

## 3. Generate a short-lived certificate public key

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Access controls** > **Service credentials**.

2. Go to the **SSH** tab.

3. In the **Application** dropdown, choose the Access application that represents your SSH server.

4. Select **Generate certificate**. A row will appear with a public key scoped to your application.

5. Save the key or keep it somewhere convenient for configuring your server. You can return to copy this public key any time in the Service Auth dashboard.

## 4. Save your public key

1. Copy the public key generated from the dashboard in Step 3.

1) Use the following command to change directories to the SSH configuration directory on the remote target machine:

   ```sh
   cd /etc/ssh
   ```

2) Once there, you can use the following command to both generate the file and open a text editor to input/paste the public key.

   ```sh
   vim ca.pub
   ```

3) In the `ca.pub` file, paste the public key without any modifications.

   ```txt
   ecdsa-sha2-nistp256 <redacted> open-ssh-ca@cloudflareaccess.org
   ```

   The `ca.pub` file can hold multiple keys, listed one per line. Empty lines and comments starting with `#` are also allowed.

4) Save the `ca.pub` file. In some systems, you may need to use the following command to force the file to save depending on your permissions:

   ```bash
   :w !sudo tee %
   :q!
   ```

## 5. Modify your `sshd_config` file

Configure your SSH server to trust the Cloudflare SSH CA by updating the `sshd_config` file on the remote target machine.

1. While in the `/etc/ssh` directory on the remote machine, open the `sshd_config` file.

   ```sh
    sudo vim /etc/ssh/sshd_config
   ```

2. Press `i` to enter insert mode, then add the following lines at the top of the file, above all other directives:

   ```txt
   PubkeyAuthentication yes
   TrustedUserCAKeys /etc/ssh/ca.pub
   ```

   Be aware of your include statements

   If there are any include statements below these lines, the configurations in those files will not take precedence.

3. Press `esc` and then type `:x` and press `Enter` to save and exit.

## 6. Restart your SSH server

Once you have modified your `sshd` configuration, reload the SSH service on the remote machine for the changes to take effect.

* Debian/Ubuntu

  For Debian/Ubuntu:

  ```sh
  sudo systemctl reload ssh
  ```

* CentOS/RHEL

  For CentOS/RHEL 7 and newer:

  ```sh
  sudo systemctl reload sshd
  ```

## 7. Connect as a user

### Configure your client SSH config

On the client side, [configure your device](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/) to use Cloudflare Access to reach the protected machine. To use short-lived certificates, you must include the following settings in your SSH config file (`~/.ssh/config`).

To save time, you can use the following cloudflared command to print the required configuration command:

```sh
cloudflared access ssh-config --hostname vm.example.com --short-lived-cert
```

If you prefer to configure manually, this is an example of the generated SSH config:

```txt
Match host vm.example.com exec "/usr/local/bin/cloudflared access ssh-gen --hostname %h"
    HostName vm.example.com
    ProxyCommand /usr/local/bin/cloudflared access ssh --hostname %h
    IdentityFile ~/.cloudflared/vm.example.com-cf_key
    CertificateFile ~/.cloudflared/vm.example.com-cf_key-cert.pub
```

### Connect through a browser-based terminal

End users can connect to the SSH session without any configuration by using Cloudflare's browser-based terminal. To enable, refer to [Browser-rendered terminal](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/browser-rendering/).

By default, the browser-based terminal prompts the user for a username/password login. If you would like to use certificate based authentication, make sure you have [created a short-lived certificate](#3-generate-a-short-lived-certificate-public-key) for the specific Access application configured for browser-rendered SSH.

***

Your SSH server is now protected behind Cloudflare Access — users will be prompted to authenticate with your identity provider before they can connect. You can also enable SSH command logging by configuring a [Gateway Audit SSH policy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/ssh-logging/).
